## -*-Tcl-*-
 # ###################################################################
 #  HTML mode - tools for editing HTML documents
 # 
 #  FILE: "htmlCustom.tcl"
 #                                    created: 96-06-29 21.36.50 
 #                                last update: 99-04-24 13.19.09 
 #  Author: Johan Linde
 #  E-mail: <jlinde@telia.com>
 #     www: <http://www.theophys.kth.se/~jl/Alpha.html>
 #  
 # Version: 2.1.4
 # 
 # Copyright 1996-1999 by Johan Linde
 #  
 # This software may be used freely, and distributed freely, as long as the 
 # receiver is not obligated in any way by receiving it.
 #  
 # If you make improvements to this file, please share them!
 # 
 # ###################################################################
 ##

proc htmlDisabled {} {
	alertnote "Disabled function!"
	error "Disabled function!"
}

#
# Defining new HTML elements.
#
proc htmlNewElement {} {
	global htmlElemAttrOptional1 htmlURLAttr htmlColorAttr htmlWindowAttr htmlElemAttrUsed
	global PREFS htmlElemAttrRequired1 htmlElemAttrChoices1 htmlElemAttrNumber1
	global htmlElemEventHandler1 htmlElemProc htmlElemKeyBinding htmlPlugins
	global HTMLmodeVars specURL specColor specWindow htmlSpecURL htmlSpecColor htmlSpecWindow
	global htmlVersion htmlShownWarning htmlAdditionExist cssModeIsLoaded
	
	if {[info exists htmlShownWarning]} {htmlDisabled}
	set invalidInput 1
	set values {"" 1 1 0 0}
	while {$invalidInput} {
		set box "-t {New element} 10 10 100 25 -e [list [lindex $values 0]] 110 10 250 25 \
		-c {Has closing tag} [lindex $values 1] 10 40 150 55 \
		-t {Element type} 10 80 100 95 -r Normal [lindex $values 2] 10 100 100 115 \
		-r {INPUT element with TYPE given above} [lindex $values 3] 10 120 300 135 \
		-r {Plug-in} [lindex $values 4] 10 140 100 155 \
		-b OK 20 170 85 190 -b Cancel 105 170 170 190"
		set values [eval [concat dialog -w 340 -h 200 $box]]
		if {[lindex $values 6]} {return}
		set element [string toupper [string trim [lindex $values 0]]]
		set closingTag [lindex $values 1]
		if {[lindex $values 2]} {
			set elemType normal
		} elseif {[lindex $values 3]} {
			set elemType input
		} else {
			set elemType plugin
		}
		# Check that input is ok.
		if {![string length $element]} {
			alertnote "You must specify the element."
		} elseif {[info exists htmlElemAttrOptional1($element)]} {
			alertnote "The element $element is already defined."
			return
		} elseif {![regexp {^[-_a-zA-Z0-9]+$} $element]} {
			alertnote "Invalid characters in element name. For example, it may not contain spaces."
		} else {
			set invalidInput 0
		}
	}

	# Get a key binding.
	if {[catch {dialog::getAKey $element ""} keyStr]} {return}
	
	# Get the attributes	
	set allattributes [htmlGetCustomAttrs $element {}]
	if {![string length $allattributes]} {return}
	set optional [lindex $allattributes 0]
	set AttrRequired [lindex $allattributes 1]
	set AttrNumber [lindex $allattributes 2]
	set AttrChoices [lindex $allattributes 3]
	set EventHandler [lindex $allattributes 4]
	set URL [lindex $allattributes 5]
	set Color [lindex $allattributes 6]
	set Window [lindex $allattributes 7]
	# Get the layout.
	if {$elemType != "normal" || !$closingTag} {
		set customproc [htmlSetCustProc1 {0 0} $elemType $element]
	} else {
		set customproc [htmlSetCustProc2 {1 0 0 0} $element]
	}
	if {![string length $customproc]} {return}
	
	# Save the element
	message "Saving new element"
	set isfile [file exists $PREFS:HTMLadditions.tcl]
	if {![file exists $PREFS]} {mkdir $PREFS}
	set fid [open $PREFS:HTMLadditions.tcl a+]
	if {!$isfile} {puts $fid $htmlVersion}
	puts $fid "$element \{set htmlElemKeyBinding($element) [list $keyStr]\}"
	set htmlElemKeyBinding($element) $keyStr
	htmlDeleteCache "CSS keybindings cache"
	if {[info exists cssModeIsLoaded]} {cssBindOneKey $keyStr $element}
	puts $fid "$element \{set htmlElemProc($element) [list $customproc]\}"
	set htmlElemProc($element) $customproc
	foreach rcne [list AttrRequired AttrChoices AttrNumber EventHandler] {
		if {[llength [set $rcne]]} {
			puts $fid "$element \{set htmlElem${rcne}1($element) [list [set $rcne]]\}"
			set htmlElem${rcne}1($element) [set $rcne]
		}
	}
	# Remove possible old versions of htmlElemAttrUsed
	if {[info exists htmlElemAttrUsed($element)]} {
		unset htmlElemAttrUsed($element)
		removeArrDef htmlElemAttrUsed $element
	}
	
	puts $fid "$element \{set htmlElemAttrOptional1($element) [list $optional]\}"
	set htmlElemAttrOptional1($element) $optional
	foreach ucw [list URL Color Window] {
		if {[llength [set $ucw]]} {
			foreach a [set $ucw] {
				puts $fid "$element \{lappend html${ucw}Attr $a\}"
				lappend html${ucw}Attr $a
			}
		}
	}
	if {$elemType == "plugin"} {
		puts $fid "$element \{lappend htmlPlugins $element\}"
		lappend htmlPlugins $element
	}
	foreach ucw [list URL Color Window] {
		if {[llength [set spec$ucw]]} {
			puts $fid "$element \{lappend htmlSpec$ucw [set spec$ucw]\}"
			append htmlSpec$ucw " " [set spec$ucw]
		}
	}
	close $fid
	
	set htmlAdditionExist 1
	htmlRebuildMenu "Inserting new element in menu"
	htmlEnableExtend [info exists htmlElemKeyBinding] $htmlAdditionExist	
	if {!$HTMLmodeVars(simpleColoring)} {
		regModeKeywords -a -k $HTMLmodeVars(tagColor) HTML [concat "<$element" "/$element"]
		regModeKeywords -a -k $HTMLmodeVars(attributeColor) HTML [concat $AttrRequired $optional]
	}
	message "Done."
	if {[llength $optional]} {htmlUseAttributes2 $element}
	unset specURL
	unset specColor
	unset specWindow
}

# Get attributes to custom element.
proc htmlGetCustomAttrs {element allattrs {nomore 1}} {
	global htmlURLAttr htmlColorAttr htmlWindowAttr
	global specURL specColor specWindow
	
	set allHTMLattrs [htmlGetAllAttrs]
	set optional {}
	set AttrRequired {}
	set AttrChoices {}
	set AttrNumber {}
	set EventHandler {}
	set URL {}
	set Color {}
	set Window {}
	set specURL {}
	set specColor {}
	set specWindow {}
	set i 0
	set dispAttr $allattrs
	
	while {1} {
		incr i
		if {[catch {htmlCustomInpAttr $element $i $dispAttr $nomore} attribute]} {
			if {$attribute != "Remove last!"} {return}
			set toremove [lindex $dispAttr [expr [llength $dispAttr] - 1]]
			set dispAttr [lreplace $dispAttr [expr [llength $dispAttr] - 1] [expr [llength $dispAttr] - 1]]
			set allattrs [lreplace $allattrs [expr [llength $allattrs] - 1] [expr [llength $allattrs] - 1]]
			set elemrm [lindex $toremove 0]
			if {[lindex $toremove 1] == "(Flag)"} {
				if {[set ind [lsearch -exact $AttrRequired $elemrm]] >=0} {
					set AttrRequired [lreplace $AttrRequired $ind $ind]
				} elseif {[set ind [lsearch -exact $optional $elemrm]] >=0} {
					set optional [lreplace $optional $ind $ind]
				}
			} else {
				foreach l [list optional AttrRequired AttrChoices AttrNumber EventHandler URL Color Window] {
					set tmp {}
					foreach m [set $l] {
						if {![string match "${elemrm}=*" $m]} {
							lappend tmp $m
						}
					}
					set $l $tmp
				}
			}
			foreach l [list URL Color Window] {
				if {[set where [lsearch -exact [set spec$l] "${element}=[string trimright $elemrm =]"]] >= 0 || \
				[set where [lsearch -exact [set spec$l] "${element}!=[string trimright $elemrm =]"]] >= 0} {
					set spec$l [lreplace [set spec$l] $where $where]
				}
			}
			incr i -2
			continue
		}
		if {![string length $attribute]} {break}
		if {[lsearch -exact [string toupper $allattrs] [string toupper [lindex $attribute 0]]] >= 0} {
			alertnote "$element already has an attribute '[lindex $attribute 0]'."
			incr i -1
		} else {
			if {[catch {htmlCustomAttrFix $element [lindex $attribute 0] \
			[lindex $attribute 1] $allHTMLattrs} thisattr]} {
				incr i -1 
				continue
			}
			lappend allattrs [string trimright [lindex $thisattr 0] =]
			set attr [lindex $thisattr 0]
			set thistype [lindex $thisattr 1]
			if {[lindex $attribute 2]} {
				lappend AttrRequired $attr
			} elseif {$thistype != "Event handler"} {
				lappend optional $attr
			} else {
				lappend EventHandler $attr
			}
			set attrext [expr ([lsearch -exact $allHTMLattrs $attr] >= 0 || [lsearch -exact $allHTMLattrs [string trimright $attr =]] >= 0)]
			if {$thistype == "Choices"} {
				foreach c [lindex $thisattr 2] {
					lappend AttrChoices "$attr$c"
				}
			} elseif {$thistype == "Number"} {
				lappend AttrNumber "$attr[lindex $thisattr 2]"
			} elseif {$thistype == "URL" && [lsearch -exact $htmlURLAttr $attr] < 0 && !$attrext} {
				lappend URL $attr
			} elseif {$thistype == "Color" && [lsearch -exact $htmlColorAttr $attr] < 0 && !$attrext} {
				lappend Color $attr
			} elseif {$thistype == "Window" && [lsearch -exact $htmlWindowAttr $attr] < 0 && !$attrext} {
				lappend Window $attr
			}
			lappend dispAttr "[string trimright $attr =] (${thistype})"
		}
	}
	return [list $optional $AttrRequired $AttrNumber $AttrChoices $EventHandler $URL $Color $Window]
}

# Dialog for giving a new attribute.
proc htmlCustomInpAttr {element num allattrs nomore} {
	set typeList [list Other Number Choices Flag URL Color Window {Event handler}]
	set values {0 0 {} Other 0}
	set invalidInput 1
	while {$invalidInput} {
		set box "-t {Attribute $num for $element} 10 10 330 25 \
		-e [list [lindex $values 2]] 10 40 150 55 \
		-t Type: 170 40 205 55 \
		-m [list [concat [list [lindex $values 3]] $typeList]] \
		210 40 330 55 -c Required [lindex $values 4] 10 70 130 85"
 		if {$num > 1} {append box " -b {Remove last} 340 100 450 120"}
 		if {$nomore || $num > 1} {append box " -b {No more attributes} 340 70 480 90"}
		set wi 10
		set ht 120
		if {[llength $allattrs]} {
			append box " -t {All attributes} 10 100 200 115"
			foreach ch $allattrs {
				append box " -t [list $ch] $wi $ht [expr $wi + 195] [expr $ht + 15]"
				incr wi 200
				if {$wi == 410} {
					set wi 10
					incr ht 20
				}
			}
		}
		if {$wi == 210} {incr ht 20}
		if {$ht < 130} {set ht 130}
		set values [eval [concat dialog -w 490 -h $ht \
		-b OK 340 10 405 30 -b Cancel 340 40 405 60 $box]]
		if {[lindex $values 1]} {
			error "Cancel"
		} elseif {$num > 1 && [lindex $values 5]} {
			error "Remove last!"
		} elseif {[lindex $values 0]} {
			set thisattr [string trim [lindex $values 2]]
			set thistype [lindex $values 3]
			if {$thistype != "Event handler"} {set thisattr [string toupper $thisattr]}
			set required [lindex $values 4]
			if {![regexp {^[-_a-zA-Z0-9]*$} $thisattr]} {
				alertnote "Invalid characters in attribute. For example, it may not contain spaces."
			} elseif {[string length $thisattr]} {
				if {$required && $thistype == "Event handler"} {
					alertnote "Event handlers cannot be required attributes. It will be optional."
					set required 0
				}
				set invalidInput 0
			}
		} else {
			return
		}
	}

	return [list $thisattr $thistype $required]
}

# Dialogs to give more info about new attributes.
proc htmlCustomAttrFix {element attr type allHTMLattrs {allchoices ""}} {
	global htmlURLAttr htmlColorAttr htmlWindowAttr
	global specURL specColor specWindow

	# Check for special case with URL etc. if not called from htmlCustomNewChoice 
	# (then allchoices has length >0)
	foreach ucw [list URL Color Window] {
		if {[lsearch -exact [set html${ucw}Attr] "$attr="] >= 0 && $type != $ucw && ![llength $allchoices]} {
			lappend spec$ucw "$element!=$attr"
		}
	}
	
	switch $type {
		Other {return [list "$attr=" $type]}
		Number {
			set values {0 0 0 {} 0}
			while {1} {
				set box "-t {Range for $attr} 60 10 290 25 -t {Minvalue:} 10 40 100 55 \
				-e [list [lindex $values 2]] 110 40 130 55 -t {Maxvalue:} 150 40 240 55 \
				-e [list [lindex $values 3]] 250 40 270 55 -c {Value may be given in percent} \
				[lindex $values 4] 10 65 250 80"
				set values [eval [concat dialog -w 300 -h 120 \
				-b OK 20 90 85 110 -b Cancel 105 90 170 110 $box]]
				set min [string trim [lindex $values 2]]
				set max [string trim [lindex $values 3]]
				set percent [lindex $values 4]
				if {[lindex $values 1]} {
					error "Cancel"
				} elseif {[lindex $values 0]} {
					if {![htmlIsInteger $min]} {
						alertnote "A minimum value must be specified."
					} elseif {[string length $max] && ![htmlIsInteger $max]} {
						alertnote "Not a valid number for maximum value."
					} elseif {[string length $max] && $max < $min} {
						alertnote "Maxvalue is smaller than minvalue."
					} else {
						break
					}
				}
			}
			set number "$min:"
			if {[string length $max]} {
				append number "$max:"
			} else {
				append number "i:"
			}
			if {$percent} {
				append number "%"
			} else {
				append number "n"
			}
			return [list "$attr=" $type $number]
		}
		Choices {
			set i 0
			set choices {}
			while {1} {
				incr i
				set values {0 0 {}}
				set invalidInput 1
				while {$invalidInput} {
					set box "-t {Choice $i for $attr} 10 10 210 25 \
					-e [list [lindex $values 2]] 10 40 200 55"
					if {$i > 1} {append box " -b {No more choices} 220 70 340 90 -b {Remove last} 220 100 340 120"}
					set wi 10
					set ht 90
					if {[llength $allchoices]} {
						append box " -t {All choices} 10 70 200 85"
						foreach ch $allchoices {
							append box " -t $ch $wi $ht [expr $wi + 95] [expr $ht + 15]"
							incr wi 100
							if {$wi == 210} {
								set wi 10
								incr ht 20
							}
						}
					}
					if {$wi == 110} {incr ht 20}
					if {$ht < 130} {set ht 130}
					set values [eval [concat dialog -w 350 -h $ht \
					-b OK 220 10 285 30 -b Cancel 220 40 285 60 \
					$box]]
					if {[lindex $values 1]} {
						error "Cancel"
					} elseif {$i > 1 && [lindex $values 3] } {
						return [list "$attr=" $type $choices]
					} elseif {$i > 1 && [lindex $values 4]} {
						incr i -1
						set choices [lreplace $choices [expr [llength $choices] - 1] [expr [llength $choices] - 1]]
						set allchoices [lreplace $allchoices [expr [llength $allchoices] - 1] [expr [llength $allchoices] - 1]]
					} elseif {[lindex $values 0]} {
						set thischoice [string toupper [string trim [lindex $values 2]]]
						if {![regexp {^[-_a-zA-Z0-9\.]*$} $thischoice]} {
							alertnote "Invalid characters in choice.  For example, it may not contain spaces."
						} elseif {[string length $thischoice]} {
							if {[lsearch -exact $allchoices $thischoice] >=0 } {
								alertnote "$attr already has a choice '$thischoice'."
							} else {
								set invalidInput 0
							}
						}
					}
				}
				lappend choices $thischoice
				lappend allchoices $thischoice
			}
		}
		Flag {return [list $attr $type]}
		URL {
			if {[lsearch -exact $htmlURLAttr "$attr="] < 0 && ([lsearch -exact $allHTMLattrs "$attr="] >= 0
			|| [lsearch -exact $allHTMLattrs $attr] >= 0)} {
				lappend specURL "${element}=$attr"
			}
			return [list "$attr=" $type]
		}
		Color {
			if {[lsearch -exact $htmlColorAttr "$attr="] < 0 && ([lsearch -exact $allHTMLattrs "$attr="] >= 0
			|| [lsearch -exact $allHTMLattrs $attr] >= 0)} {
				lappend specColor "${element}=$attr"
			}
			return [list "$attr=" $type]
		}
		Window {
			if {[lsearch -exact $htmlWindowAttr "$attr="] < 0 && ([lsearch -exact $allHTMLattrs "$attr="] >= 0
			|| [lsearch -exact $allHTMLattrs $attr] >= 0)} {
				lappend specWindow "${element}=$attr"
			}
			return [list "$attr=" $type]
		}
		"Event handler" {
			return [list "$attr=" $type]
		}
	}
	
}

proc htmlSetCustProc1 {values elemType element} {
	set box "-t {Layout} 80 10 180 25 \
	-c {Always a new line before tag.} [lindex $values 0] 10 40 225 55 \
	-c {Always a new line after tag.} [lindex $values 1] 10 60 225 75 \
	-b OK 20 90 85 110 -b Cancel 105 90 170 110"
	set values [eval [concat dialog -w 230 -h 120 $box]]
	if {[lindex $values 3]} {return}
	switch $elemType {
		normal {set  customproc "htmlBuildOpening $element"}
		input {set customproc "htmlBuildInputElem $element"}
		plugin {set customproc "htmlBuildOpening EMBED"}
	}
	lappend customproc [lindex $values 0] [lindex $values 1]
	if {$elemType == "plugin"} {lappend customproc $element}
	return $customproc
}

proc htmlSetCustProc2 {values element} {
	set box "-t {Layout} 80 10 180 25 \
	-r {text<TAG>text</TAG>text} [lindex $values 0] 10 40 200 60 \
	-r {text\r<TAG>text</TAG>\rtext} [lindex $values 1] 10 70 150 130 \
	-r {blank line\r<TAG>text</TAG>\rblank line} [lindex $values 2] 10 140 150 200 \
	-r {blank line\r<TAG>\rtext\r</TAG>\rblank line} [lindex $values 3] 10 210 150 310"
	set values [eval [concat dialog -w 200 -h 350 \
	-b OK 20 320 85 340 -b Cancel 105 320 170 340 $box]]
	if {[lindex $values 1]} {return}
	if {[lindex $values 2]} {set customproc "htmlBuildElem $element"}
	if {[lindex $values 3]} {set customproc "htmlBuildCRElem $element"}
	if {[lindex $values 4]} {set customproc "htmlBuildCRElem $element 1"}
	if {[lindex $values 5]} {set customproc "htmlBuildCR2Elem $element"}
	return $customproc
}

# Add new attributes to an element.
proc htmlNewAttributes {} {
	global htmlElemAttrOptional1 htmlURLAttr htmlColorAttr htmlWindowAttr htmlElemKeyBinding
	global PREFS htmlElemAttrRequired1 htmlElemAttrChoices1 htmlElemAttrNumber1
	global htmlElemEventHandler1 HTMLmodeVars htmlSpecURL htmlSpecColor htmlSpecWindow
	global specURL specColor specWindow htmlVersion htmlShownWarning htmlAdditionExist
	
	if {[info exists htmlShownWarning]} {htmlDisabled}
	
	if {[catch {listpick -p "Select element to add attributes to." \
	[lsort [array names htmlElemAttrOptional1]]} element] || \
	![string length $element]} {return}
	set allattrs {}
	foreach e [htmlGetRequired $element] {
		lappend allattrs [string trimright $e =]
	}
	foreach e [htmlGetOptional $element 1] {
		lappend allattrs [string trimright $e =]
	} 
	set attributes [htmlGetCustomAttrs $element $allattrs 0]
	if {![string length [join $attributes ""]]} {return}
	set AttrOptional [lindex $attributes 0]
	set AttrRequired [lindex $attributes 1]
	set AttrNumber [lindex $attributes 2]
	set AttrChoices [lindex $attributes 3]
	set EventHandler [lindex $attributes 4]
	set URL [lindex $attributes 5]
	set Color [lindex $attributes 6]
	set Window [lindex $attributes 7]
	
	if {[regexp { } $element]} {
		set arg "\[list $element\]"
	} else {
		set arg $element
	}
	
	# Save the element
	message "Saving new attributes"
	set isfile [file exists $PREFS:HTMLadditions.tcl]
	if {![file exists $PREFS]} {mkdir $PREFS}
	set fid [open $PREFS:HTMLadditions.tcl a+]
	if {!$isfile} {puts $fid $htmlVersion}
	foreach rcne [list AttrRequired AttrChoices AttrNumber EventHandler AttrOptional] {
		if {[string length [set $rcne]]} {
			puts $fid "[list $element] \{lappend htmlElem${rcne}1($arg) [set $rcne]\}"
			append htmlElem${rcne}1($element) " " [set $rcne]
		}
	}
	foreach ucw [list URL Color Window] {
		if {[string length [set $ucw]]} {
			foreach a [set $ucw] {
				puts $fid "[list $element] \{lappend html${ucw}Attr $a\}"
				lappend html${ucw}Attr $a
			}
		}
	}
	foreach ucw [list URL Color Window] {
		if {[llength [set spec$ucw]]} {
			puts $fid "[list $element] \{lappend htmlSpec$ucw [set spec$ucw]\}"
			append htmlSpec$ucw " " [set spec$ucw]
		}
	}
	close $fid
	set htmlAdditionExist 1
	htmlEnableExtend [info exists htmlElemKeyBinding] $htmlAdditionExist	
	if {!$HTMLmodeVars(simpleColoring)} {
		regModeKeywords -a -k $HTMLmodeVars(attributeColor) \
		HTML [concat $AttrRequired $AttrOptional]	
	}
	unset specURL
	unset specColor
	unset specWindow
	message "Done."
	if {[llength [htmlGetOptional $element 1]]} {htmlUseAttributes2 $element}
}

# Add new choices to an attribute with predefined choices.
proc htmlNewChoices {} {
	global htmlElemAttrChoices1 PREFS htmlVersion htmlShownWarning htmlAdditionExist
	global htmlElemKeyBinding
	
	if {[info exists htmlShownWarning]} {htmlDisabled}

	if {[catch {listpick -p "Select element to add choices to." \
	[lsort [array names htmlElemAttrChoices1]]} element] || \
	![string length $element]} {return}
	set choiceatts ""
	foreach e $htmlElemAttrChoices1($element) {
		regexp {[^=]*} $e attr
		if {[lsearch $choiceatts $attr] < 0} {lappend choiceatts $attr}
	}
	if {[catch {listpick -p "Select attribute to add choices to." [lsort $choiceatts]} attr] || \
	![string length $attr]} {return}
	foreach c $htmlElemAttrChoices1($element) {
		if {[string match "${attr}=*" $c]} {
			lappend allchoices [string range $c [expr [string length $attr] + 1] end]
		}	
	}
	
	set newchoices [htmlCustomAttrFix $element $attr Choices [htmlGetAllAttrs] $allchoices]
	foreach c [lindex $newchoices 2] {
		lappend choices "${attr}=$c"
	}
	
	if {[regexp { } $element]} {
		set arg "\[list $element\]"
	} else {
		set arg $element
	}
	# Save the choices
	set isfile [file exists $PREFS:HTMLadditions.tcl]
	if {![file exists $PREFS]} {mkdir $PREFS}
	set fid [open $PREFS:HTMLadditions.tcl a+]
	if {!$isfile} {puts $fid $htmlVersion}
	puts $fid "[list $element] \{lappend htmlElemAttrChoices1($arg) $choices\}"
	append htmlElemAttrChoices1($element) " " $choices
	close $fid
	set htmlAdditionExist 1
	htmlEnableExtend [info exists htmlElemKeyBinding] $htmlAdditionExist	
	message "New choices saved."
}

#
# Change key binding for a custom element.
#
proc htmlChangeKeyBinding {} {
	global htmlElemKeyBinding PREFS htmlShownWarning cssModeIsLoaded
	
	if {[info exists htmlShownWarning]} {htmlDisabled}

	if {![info exists htmlElemKeyBinding]} {
		alertnote "No custom elements are defined."
		return
	}
	if {[catch {listpick -p "Select element to change key binding for." \
	[lsort [array names htmlElemKeyBinding]]} elem] || ![string length $elem]} {return}
	if {[catch {dialog::getAKey $elem $htmlElemKeyBinding($elem)} keyStr]} {return}
	if {![file exists $PREFS:HTMLadditions.tcl]} {
		alertnote "Cannot find 'HTMLadditions.tcl'. Key binding cannot be changed."
		return
	}
	set fid [open $PREFS:HTMLadditions.tcl r]
	set filecont [string trimright [read $fid] "\n"]
	close $fid
	foreach line [split $filecont "\n"] {
		if {[lindex $line 0] == $elem && [regexp {htmlElemKeyBinding} $line]} {
			append newlines "$elem \{set htmlElemKeyBinding($elem) [list $keyStr]\}\n"
		} else {
			append newlines "$line\n"
		}
	}
	set fid [open $PREFS:HTMLadditions.tcl w]
	puts -nonewline $fid $newlines
	close $fid
	htmlDeleteCache "CSS keybindings cache"
	if {[info exists cssModeIsLoaded]} {
		cssBindOneKey $htmlElemKeyBinding($elem) $elem un
		cssBindOneKey $keyStr $elem
	}
	set htmlElemKeyBinding($elem) $keyStr
	htmlRebuildMenu "Redefining key binding"
	message "Done."
}

#
# Change type and layout for a custom element.
#
proc htmlChangeTypeandLayout {} {
	global htmlElemKeyBinding htmlElemProc PREFS htmlPlugins htmlShownWarning
	
	if {[info exists htmlShownWarning]} {htmlDisabled}

	if {![info exists htmlElemKeyBinding]} {
		alertnote "No custom elements are defined."
		return
	}
	if {[catch {listpick -p "Select element to change type and layout for." \
	[lsort [array names htmlElemKeyBinding]]} elem] || ![string length $elem]} {return}
	set eproc $htmlElemProc($elem)
	set proctype [lindex $eproc 0]
	if {$proctype == "htmlBuildOpening" || $proctype == "htmlBuildInputElem"} {
		if {[lindex $eproc 1] == "EMBED"} {
			set type plugin
		} else {
			set type normal
		}
		if {$proctype == "htmlBuildInputElem"} {set type input}
		set closing 0
		set values "[lindex $eproc 2] [lindex $eproc 3]"
	} else {
		set type normal
		set closing 1
		if {$proctype == "htmlBuildElem"} {set values {1 0 0 0}}
		if {$proctype == "htmlBuildCRElem" && [llength $eproc] == 2} {set values {0 1 0 0}}
		if {$proctype == "htmlBuildCRElem" && [llength $eproc] == 3} {set values {0 0 1 0}}
		if {$proctype == "htmlBuildCR2Elem"} {set values {0 0 0 1}}
	}
	set box "-t $elem 100 10 300 25 \
	-c {Has closing tag} $closing 10 40 150 55 \
	-t {Element type} 10 80 100 95 -r Normal [regexp {normal} $type] 10 100 100 115 \
	-r {INPUT element with TYPE given above} [regexp {input} $type] 10 120 300 135 \
	-r {Plug-in} [regexp {plugin} $type] 10 140 100 155 \
	-b OK 20 170 85 190 -b Cancel 105 170 170 190"
	set typeval [eval [concat dialog -w 310 -h 200 $box]]
	if {[lindex $typeval 5]} {return}
	set newclosing [lindex $typeval 0]
	if {[lindex $typeval 1]} {set newtype normal}
	if {[lindex $typeval 2]} {set newtype input; set newclosing 0}
	if {[lindex $typeval 3]} {set newtype plugin; set newclosing 0}

	if {$newclosing} {
		if {$newclosing != $closing} {set values {1 0 0 0}}
		set customproc [htmlSetCustProc2 $values $elem]
	} else {
		if {$newclosing != $closing} {set values {0 0}}
		set customproc [htmlSetCustProc1 $values $newtype $elem]
	}
	if {![string length $customproc]} {return}
	
	if {![file exists $PREFS:HTMLadditions.tcl]} {
		alertnote "Cannot find 'HTMLadditions.tcl'. Type and layout cannot be changed."
		return
	}
	set fid [open $PREFS:HTMLadditions.tcl r]
	set filecont [string trimright [read $fid] "\n"]
	close $fid
	foreach line [split $filecont "\n"] {
		if {[lindex $line 0] == $elem && [regexp {htmlElemProc} $line]} {
			append newlines "$elem \{set htmlElemProc($elem) [list $customproc]\}\n"
		} elseif {$type == "plugin" && $newtype != "plugin" && [lindex $line 0] == $elem && \
		[regexp {htmlPlugins} $line]} {
			set where [lsearch -exact $htmlPlugins $elem]
			set htmlPlugins [lreplace $htmlPlugins $where $where]
		} else {
			append newlines "$line\n"
		}
	}
	if {$newtype == "plugin" && $type != "plugin"} {
		lappend htmlPlugins $elem
		append newlines "$elem \{lappend htmlPlugins $elem\}\n"
	}
	set fid [open $PREFS:HTMLadditions.tcl w]
	puts -nonewline $fid $newlines
	close $fid
	set htmlElemProc($elem) $customproc
	message "Type and layout redefined."
}

# Remove custom element ot additions to an element.
proc htmlRemoveAdditions {} {
	global htmlElemAttrOptional1 htmlURLAttr htmlColorAttr htmlWindowAttr cssModeIsLoaded
	global PREFS htmlElemAttrRequired1 htmlElemAttrChoices1 htmlElemAttrNumber1
	global htmlElemEventHandler1 htmlElemProc htmlElemKeyBinding htmlPlugins
	global htmlSpecURL htmlSpecColor htmlSpecWindow htmlVersion htmlShownWarning htmlAdditionExist
	
	if {[info exists htmlShownWarning]} {htmlDisabled}
	
	if {![file exists $PREFS:HTMLadditions.tcl]} {
		if {[info exists htmlElemKeyBinding]} {
			alertnote "Cannot find 'HTMLadditions.tcl'. Custom additions cannot be removed."
		} else {
			alertnote "No custom additions has been made."
		}
		return
	}
	set fid [open $PREFS:HTMLadditions.tcl r]
	set additions [string trimright [read $fid] "\n"]
	close $fid
	set elems ""
	foreach line [lrange [split $additions "\n"] 1 end] {
		set element [lindex $line 0]
		if {[lsearch -exact $elems $element] < 0} {lappend elems $element}
	}
	if {[catch {listpick -p "Select element to remove additions from." [lsort $elems]} element] || \
	![string length $element] || [askyesno "Remove additions from $element?"] == "no"} {return}
	

	message "Removing additions to $element"
	set isNewElem [info exists htmlElemKeyBinding($element)]
	# If new element, unset all its variables.
	if {$isNewElem} {
		catch {unset htmlElemAttrRequired1($element)}
		catch {unset htmlElemAttrChoices1($element)}
		catch {unset htmlElemAttrNumber1($element)}
		catch {unset htmlElemAttrOptional1($element)}
		catch {unset htmlElemEventHandler1($element)}
		if {[info exists cssModeIsLoaded]} {
			cssBindOneKey $htmlElemKeyBinding($element) $element un
		}
		set tmpkey $htmlElemKeyBinding($element)
		catch {unset htmlElemKeyBinding($element)}
		catch {unset htmlElemProc($element)}
		set isPlugin [lsearch -exact $htmlPlugins $element]
		if {$isPlugin >=0 } {set htmlPlugins [lreplace $htmlPlugins $isPlugin $isPlugin]}
		if {![llength [array names htmlElemKeyBinding]]} {
			catch {unset htmlElemKeyBinding}
			if {[string length $tmpkey]} {
				set key [string tolower [string range $tmpkey [expr [string length $tmpkey] - 1] end]]
				set mods ""
				foreach m [split [string range $tmpkey 1 [expr [string length $tmpkey] - 3]] < ] {
					if {$m == "B"} {append mods z}
					if {$m == "I"} {append mods o}
					if {$m == "U"} {append mods s}
					if {$m == "O"} {append mods c}
				}
				catch {unbind '$key' <$mods> {} HTML}
			}
		}
		if {![llength [array names htmlElemProc]]} {catch {unset htmlElemProc}}
	}
	set newlines ""
	foreach line [lrange [split $additions "\n"] 1 end] {
		set command [lindex $line 1]
		if {[lindex $line 0] != $element} {
			append newlines "$line\n"
		} elseif {[lindex $command 0] == "lappend"} {
			set var [lindex $command 1]
			# Remove from URL, Color and Window lists.
			foreach ucw [list URL Color Window] {
				if {$var == "html${ucw}Attr"} {
					lappend ${ucw}maybe [lindex $command 2]
					set where [lsearch -exact [set html${ucw}Attr] [lindex $command 2]]
					set html${ucw}Attr [lreplace [set html${ucw}Attr] $where $where]
				}
				if {$var == "htmlSpec${ucw}"} {
					foreach c [lrange $command 2 end] {
						set where [lsearch -exact [set htmlSpec${ucw}] $c]
						set htmlSpec${ucw} [lreplace [set htmlSpec${ucw}] $where $where]
					}
				}
			} 
			# If added attribute to old element, remove attribute
			if {!$isNewElem && $var != "htmlURLAttr" && $var != "htmlColorAttr" && \
			$var != "htmlWindowAttr" && $var != "htmlSpecURL" && $var != "htmlSpecColor" && \
			$var != "htmlSpecWindow"} {
				regexp {([^\(]+)\(([^\)]+)\)[ ]+(.+)} [lrange $command 1 end] dummy var arg added
				foreach c $added {
					set where [lsearch -exact [set ${var}($element)] $c]
					set ${var}($element) [lreplace [set ${var}($element)] $where $where]
				}
			}
		}
	}
	# Unset empty lists for old variables.
	if {!$isNewElem} {
		foreach c [list AttrRequired AttrChoices AttrNumber EventHandler] {
			if {[info exists html${c}1($element)] && ![llength html${c}1($element)]} {
				unset html${c}1($element)
			}
		}
	}
	# URL, Color or Window attributes just removed
	# should be replaced if they are used by some other element.
	foreach ucw [list URL Color Window] {
		if {[info exists ${ucw}maybe]} {
			append newlines [htmlUCWmaybe $ucw [set ${ucw}maybe]]
		}
	}
	if {[string length $newlines]} {
		set fid [open $PREFS:HTMLadditions.tcl w]
		puts -nonewline $fid "$htmlVersion\n$newlines"
		close $fid
	} else {
		removeFile $PREFS:HTMLadditions.tcl
		set htmlAdditionExist 0
	}
	htmlDeleteCache "CSS keybindings cache"
	htmlEnableExtend [info exists htmlElemKeyBinding] $htmlAdditionExist
	if {$isNewElem} {htmlRebuildMenu "Rebuilding HTML menu"}
	message "Done."
}

proc htmlUCWmaybe {ucw maybe} {
	global htmlElemAttrRequired1 htmlElemAttrOptional1 htmlSpecURL htmlSpecColor htmlSpecWindow
	global htmlURLAttr htmlColorAttr htmlWindowAttr
	
	set newlines ""
	foreach m $maybe {
		set foundit 0
		foreach e [array names htmlElemAttrRequired1] {
			if {[lsearch -exact $htmlElemAttrRequired1($e) $m] >= 0 && \
			[lsearch -exact [set htmlSpec$ucw] "$e!=[string trimright $m =]"] < 0} {
				append newlines "[list $e] \{lappend html${ucw}Attr $m\}\n"
				lappend html${ucw}Attr $m
				set foundit 1
				break
			} 
		}
		if {$foundit} {continue}
		foreach e [array names htmlElemAttrOptional1] {
			if {[lsearch -exact $htmlElemAttrOptional1($e) $m] >= 0 && \
			[lsearch -exact [set htmlSpec$ucw] "$e!=[string trimright $m =]"] < 0} {
				append newlines "[list $e] \{lappend html${ucw}Attr $m\}\n"
				lappend html${ucw}Attr $m
				break
			} 
		}
	}
	return $newlines
}

# Remove custom element ot additions to an element.
proc htmlRemoveAttributes {} {
	global htmlElemAttrOptional1 htmlURLAttr htmlColorAttr htmlWindowAttr
	global PREFS htmlElemAttrRequired1 htmlElemAttrChoices1 htmlElemAttrNumber1
	global htmlElemEventHandler1 htmlAdditionExist htmlElemKeyBinding
	global htmlSpecURL htmlSpecColor htmlSpecWindow htmlVersion htmlShownWarning
	
	if {[info exists htmlShownWarning]} {htmlDisabled}
	
	if {![file exists $PREFS:HTMLadditions.tcl]} {
		if {[info exists htmlElemKeyBinding]} {
			alertnote "Cannot find 'HTMLadditions.tcl'. Custom additions cannot be removed."
		} else {
			alertnote "No custom additions has been made."
		}
		return
	}
	set fid [open $PREFS:HTMLadditions.tcl r]
	set additions [string trimright [read $fid] "\n"]
	close $fid
	set elems ""
	foreach line [lrange [split $additions "\n"] 1 end] {
		set element [lindex $line 0]
		if {[lsearch -exact $elems $element] < 0 && \
		[llength [concat [htmlGetRequired $element] [htmlGetOptional $element 1]]]} {
			lappend elems $element
		}
	}
	if {[catch {listpick -p "Select element to remove attributes from." [lsort $elems]} element] || \
	![string length $element]} {return}
	
	set allatts {}
	foreach line [lrange [split $additions "\n"] 1 end] {
		set command [lindex $line 1]
		if {[lindex $line 0] == $element} {
			regexp {([^\(]+)\(([^\)]+)\)[ ]+(.+)} [lrange $command 1 end] dummy var arg added
			set added [string trimleft [string trimright $added \}] \{]
			if {$var == "htmlElemAttrRequired1" || $var == "htmlElemAttrOptional1" || $var == "htmlElemEventHandler1"} {
				foreach c $added {
					if {[lsearch -exact $allatts [string trimright $c =]] < 0} {
						lappend allatts [string trimright $c =]
					}
				}
			} elseif {$var == "htmlElemAttrChoices1"} {
				foreach c $added {
					regexp {[^=]+} $c tmp
					if {[lsearch -exact $allatts $tmp] < 0} {
						lappend allatts $tmp
					}
				}
			}
		}
	}
	
	if {[catch {listpick -p "Select attributes to remove." -l [lsort $allatts]} attrs] || \
	![string length $attrs]} {return}
	
	set newlines ""
	foreach line [lrange [split $additions "\n"] 1 end] {
		set command [lindex $line 1]
		if {[lindex $line 0] != $element} {
			append newlines "$line\n"
		} else {
			set var [lindex $command 1]
			# Remove from URL, Color and Window lists.
			foreach ucw [list URL Color Window] {
				if {$var == "html${ucw}Attr"} {
					if {[lsearch -exact $attrs [string trimright [lindex $command 2] =]] >= 0} {
						lappend ${ucw}maybe [lindex $command 2]
						set where [lsearch -exact [set html${ucw}Attr] [lindex $command 2]]
						set html${ucw}Attr [lreplace [set html${ucw}Attr] $where $where]
					} else {
						append newlines "$line\n"
					}
				}
				if {$var == "htmlSpec${ucw}"} {
					set tmpadd [lrange $command 2 end]
					foreach c $tmpadd {
						regexp {[^!=]+!?=(.*)} $c dum tmp
						if {[lsearch -exact $attrs $tmp] >= 0} {
							set where [lsearch -exact [set htmlSpec${ucw}] $c]
							set htmlSpec${ucw} [lreplace [set htmlSpec${ucw}] $where $where]
							set where [lsearch -exact $tmpadd $c]
							set tmpadd [lreplace $tmpadd $where $where]
						}
					}
					if {[llength $tmpadd]} {append newlines "[list $element] \{lappend htmlSpec${ucw} $tmpadd\}\n"} 
				}
			} 
			if {[lsearch {htmlURLAttr htmlColorAttr htmlWindowAttr htmlSpecURL htmlSpecColor htmlSpecWindow htmlPlugins} $var] < 0 && \
			![string match "htmlElemKeyBinding*" $var] && ![string match "htmlElemProc*" $var]} {
				regexp {([^\(]+)\(([^\)]+)\)[ ]+(.+)} [lrange $command 1 end] dummy var arg added
				set added [string trimleft [string trimright $added \}] \{]
				foreach c $added {
					regexp {[^=]+} $c tmp
					if {[lsearch -exact $attrs $tmp] >= 0} {
						set where [lsearch -exact [set ${var}($element)] $c]
						set ${var}($element) [lreplace [set ${var}($element)] $where $where]
						set where [lsearch -exact $added $c]
						set added [lreplace $added $where $where]
					}
				}
				if {[llength $added] || ([lindex $command 0] == "set" && $var == "htmlElemAttrOptional1")} {
					if {[lindex $command 0] == "set"} {set added [list $added]}
					append newlines "[list $element] \{[lindex $command 0] ${var}($arg) $added\}\n"
				}
			}
			if {[string match "htmlElemKeyBinding*" $var] || [string match "htmlElemProc*" $var]} {
				append newlines "$line\n"
			}
		}
	}
	# Unset empty lists.
	foreach c [list AttrRequired AttrChoices AttrNumber EventHandler] {
		if {[info exists html${c}1($element)] && ![llength html${c}1($element)]} {
			unset html${c}1($element)
		}
	}
	# URL, Color or Window attributes just removed
	# should be replaced if they are used by some other element.
	foreach ucw [list URL Color Window] {
		if {[info exists ${ucw}maybe]} {
			append newlines [htmlUCWmaybe $ucw [set ${ucw}maybe]]
		}
	}
	if {[string length $newlines]} {
		set fid [open $PREFS:HTMLadditions.tcl w]
		puts -nonewline $fid "$htmlVersion\n$newlines"
		close $fid
	} else {
		removeFile $PREFS:HTMLadditions.tcl
		set htmlAdditionExist 0
	}
	htmlEnableExtend [info exists htmlElemKeyBinding] $htmlAdditionExist
	message "Attributes removed from $element."
}


#===============================================================================
#  Home pages
#===============================================================================

# Dialog to handle servers and corresponding home page folders.
proc htmlHomePages {{this ""}} {
	global modifiedModeVars HTMLmodeVars
	
	set pages $HTMLmodeVars(homePages)
	set servers $HTMLmodeVars(FTPservers)
	set touchedIt 0
	if {$this == ""} {set this }
	while {1} {
		set box "-t {Home pages} 180 10 300 30 -t {Server URLs:} 10 40 100 60 \
		-t {Home Page Folder:} 10 70 110 110 \
		-t {Include Folder:} 10 120 110 140 -t {Default file:} 10 170 100 190 \
		-t {Ftp server:} 10 200 100 220 -t {User ID:} 10 225 100 245 \
		-t Password: 10 250 100 270 -t Directory: 10 275 100 295 \
		-b OK 10 330 75 350 -b Cancel 90 330 155 350 -b New 170 330 235 350 \
		-c {Tell Big Brother} 0 320 300 440 320"
		if {[llength $pages]} {
			set pgs ""
			foreach pg $pages {
				lappend pgs "[lindex $pg 1][lindex $pg 2]"
			}
			append box " -m [list [concat $this $pgs]] 110 40 440 60"
			append box " -b Change 250 330 320 350 -b Remove 335 330 400 350"
			foreach pg $pages {
				lappend box -n "[lindex $pg 1][lindex $pg 2]" -t [lindex $pg 0] 120 70 440 110 \
				-t [lindex $pg 3] 110 170 310 190
				if {[llength $pg] == 5} {lappend box -t [lindex $pg 4] 120 120 440 160}
				foreach f $servers {
					if {[lindex $f 0] == [lindex $pg 0]} {
						lappend box -t [lindex $f 1] 120 200 440 220 \
						-t [lindex $f 2] 120 225 440 245
						set pwb ""
						for {set i 0} {$i < [string length [lindex $f 3]]} {incr i} {
							append pwb 
						}
						lappend box -t $pwb 120 250 440 270 \
						-t [lindex $f 4] 120 275 440 295
					}
				}
			}
		} else {
			append box  " -m {{None defined} {None defined}} 110 40 440 60"
		}
		set values [eval [concat dialog -w 450 -h 360 $box]]
		set this [lindex $values 4]
		if {[lindex $values 0]} {
			set HTMLmodeVars(homePages) $pages
			set HTMLmodeVars(FTPservers) $servers
			lappend modifiedModeVars {homePages HTMLmodeVars} {FTPservers HTMLmodeVars}
			if {[lindex $values 3]} {
				if {[htmlGetVersion Bbth] < 1.1} {
					alertnote "Cannot change the settings in Big Brother. You need Big Brother 1.1 or later."
				} elseif {[askyesno "Change URL mappings in Big Brother?"] == "yes"} {
					if {![app::isRunning Bbth] && [catch {app::launchBack Bbth}]} {
						alertnote "Could not find or launch Big Brother."
						return
					}
					set urlmap [htmlURLmap]
					AEBuild 'Bbth' core setd "----" "obj{want:type('mapG'),from:null(),form:'prop',seld:type('mapS')}" "data" "\[$urlmap\]"
				}
			}
			return
		} elseif {[lindex $values 1]} {
			if {!$touchedIt || [askyesno "Really cancel without saving changes?"] == "yes"} {return}
		} elseif {[lindex $values 2]} {
			set newpg {{} {} {} "index.html" {}}
			set newserver {{} {} {} {}}
			while {1} {
				if {[catch {htmlSetHomePages $pages [lindex $newpg 0] "[lindex $newpg 1][lindex $newpg 2]" [lindex $newpg 3] [lindex $newpg 4]} newpg]} {break}
				if {[htmlTestHomePage $pages $newpg]} {
					lappend pages $newpg
					if {[lindex $newserver 0] != ""} {lappend servers [concat [list [lindex $newpg 0]] $newserver]}
					set this "[lindex $newpg 1][lindex $newpg 2]"
					set touchedIt 1
					break
				}
			}
		} else {
			for {set i 0} {$i < [llength $pages]} {incr i} {
				if {"[lindex [lindex $pages $i] 1][lindex [lindex $pages $i] 2]" == $this} {
					if {[lindex $values 5]} {
						set newpg [lindex $pages $i]
						set pg "[lindex $newpg 1][lindex $newpg 2]"
						set oldpage [lindex $newpg 0]
						set newserver {{} {} {} {}}
						foreach f $servers {
							if {[lindex $f 0] == $oldpage} {set newserver [lrange $f 1 end]}
						}
						while {1} {
							if {[catch {htmlSetHomePages $pages [lindex $newpg 0] "[lindex $newpg 1][lindex $newpg 2]" [lindex $newpg 3] [lindex $newpg 4] $pg} newpg]} {break}
							if {[htmlTestHomePage $pages $newpg $pg]} {
								set pages [lreplace $pages $i $i $newpg]
								set ns ""
								foreach f $servers {
									if {[lindex $f 0] != $oldpage} {lappend ns $f}
								}
								set servers $ns
								if {[lindex $newserver 0] != ""} {lappend servers [concat [list [lindex $newpg 0]] $newserver]}
								set this "[lindex $newpg 1][lindex $newpg 2]"
								set touchedIt 1
								break
							}
						}
					} else {
						set tpg [lindex [lindex $pages $i] 0]
						set ns ""
						foreach f $servers {
							if {[lindex $f 0] != $tpg} {lappend ns $f}
						}
						set servers $ns
						set pages [lreplace $pages $i $i]
						set touchedIt 1
					}
				}
			}
		}
	}
}

# Dialog to define or change a home page.
proc htmlSetHomePages {pages folder url defFile inclFld {pg ""}} {
	upvar newserver server
	while {1} {
		set pwb ""
		for {set i 0} {$i < [string length [lindex $server 2]]} {incr i} {
			append pwb 
		}
		set val [dialog -w 450 -h 320 -t "Home Page Folder:" 10 10 135 30 -t $folder 140 10 440 50 \
		-t "Include Folder:" 10 60 110 80 -t $inclFld 130 60 440 100 \
		-t "Server URL:" 10 110 90 130 \
		-e $url 100 110 440 125 -t "Default file:" 10 145 90 160 \
		-e $defFile 100 145 440 160 \
		-t "Ftp Server:" 10 180 90 200 -e [lindex $server 0] 100 180 440 195 \
		-t "User ID:" 10 205 90 225 -e [lindex $server 1] 100 205 440 220 \
		-t "Password:" 10 230 85 250 -t $pwb 160 230 440 245 \
		-t "Directory:" 10 260 90 280 -e [lindex $server 3] 100 260 440 275 \
		-b OK 20 290 85 310 -b Cancel 110 290 175 310  -b Set 90 230 150 250 \
		-b "Set" 20 30 80 50 -b "Set" 10 80 60 100 -b "Unset" 70 80 120 100]
		set url [string trim [lindex $val 0]]
		set defFile [string trim [lindex $val 1]]
		set ftp [string trim [lindex $val 2]]
		regexp {^(ftp://)?(.*)$} $ftp dum1 dum2 ftp
		set dir [string trimright [string trim [lindex $val 4]] /]
		if {[lindex $val 7] && ![catch {htmlGetPassword $ftp} newpw]} {
			set pw $newpw
		} else {
			set pw [lindex $server 2]
		}
		set server [list $ftp [string trim [lindex $val 3]] \
		$pw $dir]
		if {[lindex $val 8] && ![catch {htmlGetAhpFolder "Home Page Folder:" $pages $pg} fld]} {
			set folder $fld
		} elseif {[lindex $val 9] && ![catch {htmlGetAhpFolder "Include Folder:" $pages $pg} fld]} {
			set inclFld $fld
		} elseif {[lindex $val 10]} {
			set inclFld ""
		} elseif {[lindex $val 5]} {
			if {![regexp {://} $url] && $url != ""} {
				alertnote "The server URL can't be a relative URL."
			} elseif {[lindex $server 0] != "" && [lindex $server 1] == ""} {
				alertnote "When you specify an ftp server you must give the user ID."
			} elseif {$folder == $inclFld} {
				alertnote "The home page folder and include folder can't be the same folder."
			} elseif {[string length $folder] && [string length $url] && [string length $defFile]} {
				regexp -indices {://} $url css
				set sl [string first / [string range $url [expr [lindex $css 1] + 1] end]]
				if {$sl < 0} {
					set base "$url/"
					set path ""
				} elseif {[string index $url [expr [string length $url] -1]] != "/"} {
					alertnote "A directory URL ending with a slash expected."
					continue
				} else {
					set base [string range $url 0 [expr [lindex $css 1] + $sl + 1]]
					set path [string range $url [expr [lindex $css 1] + $sl + 2] end]
				}
				set ret [list $folder $base $path $defFile]
				if {$inclFld != ""} {lappend ret $inclFld}
				return  $ret
			} else {
				alertnote "Home page folder, server URL, and default file must be specified."
			}
		} elseif {[lindex $val 6]} {
			error ""
		}
	}
}

proc htmlTestHomePage {pages newpg {pg ""}} {
	foreach p $pages {
		if {"[lindex $p 1][lindex $p 2]" == $pg} {continue}
		if {[string match "[lindex $p 1][lindex $p 2]*" "[lindex $newpg 1][lindex $newpg 2]"] ||
		[string match "[lindex $newpg 1][lindex $newpg 2]*" "[lindex $p 1][lindex $p 2]"]} {
			alertnote "There is already a home page folder for [lindex $p 1][lindex $p 2].\
			It overlaps with this one."
			return 0
		}
	}
	return 1
}	

proc htmlGetAhpFolder {txt pages pg} {
	set fld [htmlGetDir $txt]
	set msg {"home page" "" "" "" include}
	foreach p $pages {
		foreach i {0 4} {
			if {"[lindex $p 1][lindex $p 2]" == $pg && [regexp -nocase [lindex $msg $i] $txt]
			|| [llength $p] == $i} {continue}
			if {[string match "[lindex $p $i]:*" "$fld:"] || [string match "$fld:*" "[lindex $p $i]:"]} {
				alertnote "This folder overlaps with the [lindex $msg $i] folder for [lindex $p 1][lindex $p 2]."
				error ""
			}
		}
	}
	return $fld
}

